/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerNetworkEvents;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import fuzs.puzzleslib.impl.core.ClientboundModListMessage;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class ModContext {
    private static final Map<String, ModContext> MOD_CONTEXTS = Maps.newConcurrentMap();
    protected final String modId;
    private final Queue<Buildable> buildables = Queues.newConcurrentLinkedQueue();
    private final Map<class_2960, Runnable> clientModConstructors = Maps.newConcurrentMap();
    private final Set<class_2960> constructedPairings = Sets.newConcurrentHashSet();
    private final Set<ContentRegistrationFlags> handledFlags = EnumSet.noneOf(ContentRegistrationFlags.class);
    @Nullable
    protected RegistryManager registryManager;
    @Nullable
    protected CapabilityController capabilityController;
    private boolean presentServerside = true;

    protected ModContext(String modId) {
        this.modId = modId;
    }

    public static void registerEventHandlers() {
        LoadCompleteCallback.EVENT.register(() -> {
            for (ModContext context : MOD_CONTEXTS.values()) {
                if (!context.buildables.isEmpty()) {
                    throw new IllegalStateException("Mod context for %s has %s remaining buildable(s)".formatted(context.modId, context.buildables.size()));
                }
                if (context.clientModConstructors.isEmpty()) continue;
                throw new IllegalStateException("Mod context for %s has remaining client mod constructor(s): %s".formatted(context.modId, context.clientModConstructors.keySet()));
            }
        });
        PlayerNetworkEvents.LOGGED_IN.register(serverPlayer -> PuzzlesLibMod.NETWORK.sendMessage(PlayerSet.ofPlayer(serverPlayer), new ClientboundModListMessage(MOD_CONTEXTS.keySet())));
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            ClientPlayerNetworkEvents.LOGGED_IN.register((player, multiPlayerGameMode, connection) -> {
                for (ModContext context : MOD_CONTEXTS.values()) {
                    context.presentServerside = false;
                }
            });
        }
    }

    public static ModContext get(String modId) {
        return MOD_CONTEXTS.computeIfAbsent(modId, CommonFactories.INSTANCE::getModContext);
    }

    public static Stream<CapabilityController> getCapabilityControllers() {
        return MOD_CONTEXTS.values().stream().map(context -> context.capabilityController).filter(Objects::nonNull);
    }

    public static class_2960 getPairingIdentifier(String modId, BaseModConstructor modConstructor) {
        class_2960 identifier = modConstructor.getPairingIdentifier();
        return identifier != null ? identifier : ResourceLocationHelper.fromNamespaceAndPath(modId, "main");
    }

    public static void acceptServersideMods(Collection<String> modList) {
        modList.stream().map(MOD_CONTEXTS::get).filter(Objects::nonNull).forEach(context -> {
            context.presentServerside = true;
        });
    }

    public static boolean isPresentServerside(String modId) {
        return MOD_CONTEXTS.containsKey(modId) && ModContext.MOD_CONTEXTS.get((Object)modId).presentServerside;
    }

    public abstract NetworkHandler.Builder getNetworkHandler(class_2960 var1);

    public abstract ConfigHolder.Builder getConfigHolder();

    public abstract RegistryManager getRegistryManager();

    public abstract CapabilityController getCapabilityController();

    protected <T extends Buildable> T addBuildable(T buildable) {
        Objects.requireNonNull(buildable, "buildable is null");
        this.buildables.offer(buildable);
        return buildable;
    }

    public final void scheduleClientModConstruction(class_2960 identifier, Runnable runnable) {
        if (this.constructedPairings.contains(identifier)) {
            runnable.run();
        } else {
            this.clientModConstructors.put(identifier, runnable);
        }
    }

    public final void beforeModConstruction() {
        while (!this.buildables.isEmpty()) {
            this.buildables.poll().build();
        }
    }

    public final void afterModConstruction(class_2960 identifier) {
        this.constructedPairings.add(identifier);
        Runnable runnable = this.clientModConstructors.remove(identifier);
        if (runnable != null) {
            runnable.run();
        }
    }

    public final Set<ContentRegistrationFlags> getFlagsToHandle(Set<ContentRegistrationFlags> availableFlags) {
        return (Set)availableFlags.stream().filter(Predicate.not(this.handledFlags::contains)).peek(this.handledFlags::add).collect(ImmutableSet.toImmutableSet());
    }
}

